function [melddata] = imdatameld(vdata,ipdata)
%This function takes data from punc_distill_lite and find_imgprop and
%combines it into one array containing all of the info for the vertices in
%the punc_distill_lite dataset.  Note: the channels used in
%punc_distill_lite and find_imgprop must be the same and in the same order,
%plus "WeightedCentroid" not "weightedcentroid" for now.  This is not a
%very smart function, but it works.
%Synatax:   [melddata] = imdatameld(vdata,ipdata)
%Input:     vdata = Output array from punc_distill_lite.
%           ipdata = Output structure from find_imgprop
%Output:    melddata = Data array where additional vertex information
%               is attached each represented vertex.

%Pull data out from the data structures.
matlabpool      %start workers
ch_num = size(ipdata,2);        %get the number of channels in the dataset
field_names = fieldnames(ipdata);   %get the field names of ipdata, which is a cell array ch_num x 1
ori = vdata(1,2);               %the origin channel
termi = vdata(1,7);             %the termini channel
%figure out the scale factors for x y and z if any.
scale_xyz = single(vdata(1,3:5)./ipdata(ori).WeightedCentroid(1,:));

%Lets get the melddata initiated with the first two data points, which are
%special anyway.
%Number 1
melddata = single(vdata(:,1:6));    %the ori channel data(no distance)
%now add the addition information to melddata
for i = 1:size(field_names,1)
    switch field_names{i,1}
        case {'WeightedCentroid','weightedcentroid'}
            %do nothing for now
        otherwise   %everything else...
            field_tmp = single(ipdata(ori).(field_names{i,1}));     %pull out the data for the first field.
            %now take care repeats in the melddata dataset
            %[a,b,expand_idx] = unique(melddata(:,1));        %a = the unique values, b = the index of the unique values, c = the index of all values
            expand_idx = melddata(:,1);
            field_tmp = field_tmp(expand_idx,:);            %expand values for multiple represented indexes
            melddata = horzcat(melddata,field_tmp);          %everything should be in the exact order with exact number of vertices.
    end
end
%Number 2
melddata = horzcat(melddata,single(vdata(:,7:12)));     %tack on the termi information
%now add the additional information
try
    verti_tmp = single(ipdata(termi).WeightedCentroid.*repmat(scale_xyz,size(ipdata(termi).WeightedCentroid,1),1));     %get the vertices for indexing purposes
catch
    verti_tmp = single(ipdata(termi).weightedcentroid.*repmat(scale_xyz,size(ipdata(termi).weightedcentroid,1),1));     %lower case a possibility
end
h = waitbar(0,'Appending Field to Termini: ');    %initialize progress bar.
for i = 1:size(field_names,1)
    switch field_names{i,1}
        case {'WeightedCentroid','weightedcentroid'}
            %do nothing for now
        otherwise   %everything else...
            field_tmp = single(ipdata(termi).(field_names{i,1}));     %pull out the data for the first field.
            %preallocate
            append_data = zeros(size(vdata,1),size(field_tmp,2));
            %step progressbar forward
            waitbar(i/size(field_names,1),h,['Appending Field to Termini: ',field_names{i,1}]);
            parfor j = 1:size(vdata,1)     %now look at each vertices and pull the data out in the data structure
                [tmp1,tmp2,x] = find_neighbors2(vdata(j,8:10),verti_tmp,0);  %find matching vertex
                if isempty(x)       %no matching vertex
                    append_data(j,:) = NaN(1,size(field_tmp,2));
                else                %a match pull data
                    append_data(j,:) = field_tmp(x,:);
                end
            end
            melddata = horzcat(melddata,append_data);       %append the new info
            clear append_data field_tmp tmp1 tmp2
    end
end
close(h)
clear verti_tmp h
%Number3 and beyond
h = waitbar(0,'Processing Channel: ');    %initialize progress bar.
pos = get(h,'position');               %get position of the progress bar
for i = 1:ch_num-2      %step through the rest of channels - the two channels of the base vector
    curr_col = 13+11*(i-1);     %get the start column for this channel in vdata
    curr_ch = vdata(1,curr_col);    %get the current channel #
    melddata = horzcat(melddata,single(vdata(:,[curr_col:curr_col+3,curr_col+8:curr_col+10])));     %tack on the channel information
    %now the get the vertices
    try
        verti_tmp = single(ipdata(curr_ch).WeightedCentroid.*repmat(scale_xyz,size(ipdata(curr_ch).WeightedCentroid,1),1));     %get the vertices for indexing purposes
    catch
        verti_tmp = single(ipdata(curr_ch).weightedcentroid.*repmat(scale_xyz,size(ipdata(curr_ch).weightedcentroid,1),1));     %lower case a possibility
    end
    %step progressbar forward
    waitbar(i/(ch_num-2),h,['Processing Channel: ',num2str(curr_ch)]);
    h2 = waitbar(0,'Appending Field: ','position',[pos(1) pos(2)+pos(4)+10 275 50]);    %initialize progress bar.
    for j = 1:size(field_names,1)
        switch field_names{j,1}
            case {'WeightedCentroid','weightedcentroid'}
                %do nothing for now
            otherwise   %everything else...
                field_tmp = single(ipdata(curr_ch).(field_names{j,1}));     %pull out the data for the first field.
                %preallocate
                append_data = zeros(size(vdata,1),size(field_tmp,2));
                waitbar(j/size(field_names,1),h2,['Appending Field: ',field_names{j,1}],'position',[pos(1) pos(2)+pos(4)+10 275 50]);   %show progress
                parfor k = 1:size(vdata,1)     %now look at each vertices and pull the data out in the data structure
                    [tmp1,tmp2,x] = find_neighbors2(vdata(k,curr_col+1:curr_col+3),verti_tmp,0);  %find matching vertex
                    if isempty(x)       %no matching vertex
                        append_data(k,:) = NaN(1,size(field_tmp,2));
                    else                %a match pull data
                        append_data(k,:) = field_tmp(x,:);
                    end
                end
                melddata = horzcat(melddata,append_data);       %append the new info
                clear append_data field_tmp tmp1 tmp2
        end
    end
    close(h2)
    clear verti_tmp h2
end
close(h)
matlabpool close